/*
 * Decompiled with CFR 0.152.
 */
package com.globfx.swiffchart;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;

public class SwiffChartEngine {
    static final int SCGMID_Quit = 0;
    static final int SCGMID_GetVersion = 1;
    static final int SCGMID_LoadStyle = 2;
    static final int SCGMID_SetStyleData = 3;
    static final int SCGMID_SetWidth = 4;
    static final int SCGMID_GetWidth = 5;
    static final int SCGMID_SetHeight = 6;
    static final int SCGMID_GetHeight = 7;
    static final int SCGMID_SetCompressed = 8;
    static final int SCGMID_IsCompressed = 9;
    static final int SCGMID_AnimateChart = 10;
    static final int SCGMID_IsAnimated = 11;
    static final int SCGMID_SetFrameRate = 12;
    static final int SCGMID_GetFrameRate = 13;
    static final int SCGMID_SetLooping = 14;
    static final int SCGMID_IsLooping = 15;
    static final int SCGMID_ProtectSWF = 16;
    static final int SCGMID_IsSWFProtected = 17;
    static final int SCGMID_SetTitle = 18;
    static final int SCGMID_GetTitle = 19;
    static final int SCGMID_SetSubtitle = 20;
    static final int SCGMID_GetSubtitle = 21;
    static final int SCGMID_SetSeparators = 22;
    static final int SCGMID_GetSeparators = 23;
    static final int SCGMID_SetLocaleInfo = 24;
    static final int SCGMID_SetUnicode = 25;
    static final int SCGMID_SetDataFromTxtFile = 26;
    static final int SCGMID_SetCategoriesFromString = 27;
    static final int SCGMID_SetCategoriesFromArray = 28;
    static final int SCGMID_SetCategory = 29;
    static final int SCGMID_GetCategory = 30;
    static final int SCGMID_ClearAll = 31;
    static final int SCGMID_AddSeries = 32;
    static final int SCGMID_SetSeriesCaptionsFromString = 33;
    static final int SCGMID_SetSeriesCaptionsFromArray = 34;
    static final int SCGMID_SetSeriesCaption = 35;
    static final int SCGMID_GetSeriesCaption = 36;
    static final int SCGMID_GetSeriesCount = 37;
    static final int SCGMID_GetValuesCount = 38;
    static final int SCGMID_SetSeriesXValuesFromString = 39;
    static final int SCGMID_SetSeriesXValuesFromArray = 40;
    static final int SCGMID_SetSeriesYValuesFromString = 41;
    static final int SCGMID_SetSeriesYValuesFromArray = 42;
    static final int SCGMID_SetSeriesXYValuesFromString = 43;
    static final int SCGMID_GetSeriesXValue = 44;
    static final int SCGMID_GetSeriesYValue = 45;
    static final int SCGMID_SetAxisMinValue = 46;
    static final int SCGMID_SetAxisMaxValue = 47;
    static final int SCGMID_SetAxisCrossValue = 48;
    static final int SCGMID_ResetAxisBounds = 49;
    static final int SCGMID_SetAxisTitle = 50;
    static final int SCGMID_GetAxisTitle = 51;
    static final int SCGMID_SetOutputFormat = 52;
    static final int SCGMID_SetJPGQuality = 53;
    static final int SCGMID_SetPNGCompLevel = 54;
    static final int SCGMID_ExportAsBinary = 55;
    static final int SCGMID_ExportAsFile = 56;
    static final int SCGMID_SetDocumentRoot = 57;
    static final int SCGMID_GetHTMLTag = 58;
    static final int SCGMID_GetOutputLocation = 59;
    static final int SCGMID_GetHTTPContentType = 60;
    static final int SCGMID_ClearCache = 61;
    static final int SCGMID_SetCacheName = 62;
    static final int SCGMID_SetPrivateCacheDir = 63;
    static final int SCGMID_SetMaxCacheSize = 64;
    static final int SCGMID_UseCache = 65;
    static final int SCGMID_SetTTFontsDir = 66;
    static final int SCGMID_BatchCommands = 67;
    static final int SCGMID_SetDebugMode = 68;
    static final int SCGMID_SetSeriesZValuesFromString = 69;
    static final int SCGMID_SetSeriesZValuesFromArray = 70;
    static final int SCGMID_GetSeriesZValue = 71;
    static final int SCGMID_SetSeriesColor = 72;
    static final int SCGMID_SetSeriesValueColor = 73;
    static final int SCGMID_SetSeriesTrendlineColor = 74;
    static final int SCGMID_SetAppRootUrl = 75;
    static final String hexchars = "0123456789ABCDEF";
    String install_dir;
    Process process;
    InputStream is;
    OutputStream os;
    PrintStream ps;
    boolean is_windows;

    public SwiffChartEngine() throws IOException {
        this.init(null);
    }

    public SwiffChartEngine(String string) throws IOException {
        this.init(string);
    }

    private void init(String string) throws IOException {
        String string2 = System.getProperty("os.name").toLowerCase();
        boolean bl = this.is_windows = string2.indexOf("windows") >= 0;
        this.install_dir = string == null || string.length() == 0 ? (this.is_windows ? "C:/Program files/GlobFX/Swiff Chart Generator 3" : "/usr/local/SwiffChart") : string;
        this.start();
    }

    public void start() throws IOException {
        String string;
        String string2;
        if (this.is_windows) {
            string2 = "\"" + this.install_dir + "/swfchart.exe" + "\"";
            string = "/";
        } else {
            string2 = this.install_dir + "/swfchart";
            string = "--";
        }
        String string3 = string2;
        string3 = string3 + " " + string + "int";
        string3 = string3 + " " + string + "utf8";
        string3 = string3 + " " + string + "install-dir " + this.encodeOption(this.install_dir);
        Runtime runtime = Runtime.getRuntime();
        this.process = runtime.exec(string3);
        this.is = this.process.getInputStream();
        this.os = this.process.getOutputStream();
        this.ps = new PrintStream(this.os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.finalize();
            throw throwable;
        }
        super.finalize();
    }

    public void Release() throws Exception {
        this.close();
    }

    public void close() throws Exception {
        if (this.process == null) {
            return;
        }
        this.putCmd(0);
        this.ps.flush();
        this.getAck();
        this.process.destroy();
        this.process = null;
        this.is = null;
        this.os = null;
        this.ps = null;
    }

    public void putCmd(int n) {
        this.ps.println(n);
    }

    public void putLine(String string) {
        this.ps.println(string);
    }

    public void putInteger(int n) {
        this.ps.println(n);
    }

    public void putDouble(double d) {
        this.ps.println(d);
    }

    public void putBool(boolean bl) {
        this.ps.print(bl ? "1\n" : "0\n");
    }

    public void putString(String string) {
        this.putLine(this.encodeString(string));
    }

    public void putArray(String[] stringArray) {
        this.putInteger(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.putString(stringArray[n]);
            ++n;
        }
    }

    public void putArray(int[] nArray) {
        this.putInteger(nArray.length);
        int n = 0;
        while (n < nArray.length) {
            this.putString(Integer.toString(nArray[n]));
            ++n;
        }
    }

    public void putArray(float[] fArray) {
        this.putInteger(fArray.length);
        int n = 0;
        while (n < fArray.length) {
            this.putString(Float.toString(fArray[n]));
            ++n;
        }
    }

    public void putArray(double[] dArray) {
        this.putInteger(dArray.length);
        int n = 0;
        while (n < dArray.length) {
            this.putString(Double.toString(dArray[n]));
            ++n;
        }
    }

    public void putData(String string) {
        this.putInteger(string.length());
        this.ps.print(string);
    }

    private static String str_replace(String string, String string2, String string3) {
        int n = string.length();
        int n2 = string2.length();
        if (n == 1 && n2 == 1) {
            return string3.replace(string.charAt(0), string2.charAt(0));
        }
        StringBuffer stringBuffer = new StringBuffer(string3);
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = stringBuffer.indexOf(string, n3)) == -1) {
                if (n3 != 0) break;
                return string3;
            }
            stringBuffer.replace(n4, n4 + n, string2);
            n3 = n4 + n2;
        }
        return stringBuffer.toString();
    }

    private static byte[] utf8_encode(String string) {
        byte[] byArray = null;
        try {
            byArray = string.getBytes("UTF8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray == null) {
            byArray = new byte[string.length()];
            int n = 0;
            while (n < string.length()) {
                int n2 = string.charAt(n);
                if (n2 >= 256) {
                    n2 = 63;
                }
                byArray[n] = (byte)n2;
                ++n;
            }
        }
        return byArray;
    }

    private static String utf8_decode(byte[] byArray, int n, int n2) {
        String string = null;
        try {
            string = new String(byArray, n, n2, "UTF8");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (string == null) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                int n4 = byArray[n + n3];
                if (n4 < 0) {
                    n4 += 256;
                }
                stringBuffer.append((char)n4);
                ++n3;
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    private static String utf8_decode(byte[] byArray) {
        return SwiffChartEngine.utf8_decode(byArray, 0, byArray.length);
    }

    public String urlencode(String string) {
        if (string == null) {
            return "";
        }
        byte[] byArray = SwiffChartEngine.utf8_encode(string);
        StringBuffer stringBuffer = new StringBuffer(byArray.length);
        int n = 0;
        while (n < byArray.length) {
            int n2 = byArray[n];
            if (n2 < 0) {
                n2 += 256;
            }
            if (n2 >= 48 && n2 <= 57 || n2 >= 97 && n2 <= 122 || n2 >= 65 && n2 <= 90 || n2 == 46 || n2 == 45 || n2 == 95) {
                stringBuffer.append((char)n2);
            } else {
                stringBuffer.append('%');
                stringBuffer.append(hexchars.charAt(n2 >> 4));
                stringBuffer.append(hexchars.charAt(n2 & 0xF));
            }
            ++n;
        }
        string = stringBuffer.toString();
        return string;
    }

    private static int HEX_DIGIT(int n) {
        if (n >= 48 && n <= 57) {
            return n - 48;
        }
        if (n >= 97 && n <= 102) {
            return n - 97 + 10;
        }
        if (n >= 65 && n <= 70) {
            return n - 65 + 10;
        }
        return -1;
    }

    public String urldecode(String string) {
        if (string == null) {
            return "";
        }
        byte[] byArray = new byte[string.length()];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            int n3 = string.charAt(n2);
            if (n3 == 43) {
                byArray[n++] = 32;
            } else if (n3 == 37) {
                if (n2 + 2 >= string.length()) break;
                char c = string.charAt(n2 + 1);
                char c2 = string.charAt(n2 + 2);
                int n4 = SwiffChartEngine.HEX_DIGIT(c);
                int n5 = SwiffChartEngine.HEX_DIGIT(c2);
                if (n4 != -1 && n5 != -1) {
                    int n6 = (n4 << 4) + n5;
                    if (n6 == 0) {
                        n6 = 32;
                    }
                    byArray[n++] = (byte)n6;
                    n2 += 2;
                }
            } else {
                if (n3 == 0) {
                    n3 = 32;
                }
                byArray[n++] = (byte)n3;
            }
            ++n2;
        }
        return SwiffChartEngine.utf8_decode(byArray, 0, n);
    }

    protected String encodeString(String string) {
        if (string == null) {
            return "";
        }
        string = this.urlencode(string);
        string = SwiffChartEngine.str_replace("-", "%2D", string);
        string = SwiffChartEngine.str_replace("_", "%5F", string);
        string = SwiffChartEngine.str_replace("%", "_", string);
        return string;
    }

    protected String decodeString(String string) {
        string = SwiffChartEngine.str_replace("_", "%", string);
        string = this.urldecode(string);
        return string;
    }

    protected String encodeOption(String string) {
        if (string == null) {
            return "";
        }
        string = this.urlencode(string);
        string = SwiffChartEngine.str_replace("-", "%2D", string);
        string = SwiffChartEngine.str_replace("%2F", "/", string);
        return string;
    }

    public String getLine() throws IOException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.is.read()) != -1) {
            if (n == 13) continue;
            if (n == 10) break;
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public String getString() throws IOException {
        return this.decodeString(this.getLine());
    }

    public int getInteger() throws IOException {
        return Integer.parseInt(this.getLine());
    }

    public double getDouble() throws IOException {
        return Double.parseDouble(this.getLine());
    }

    public boolean getBool() throws IOException {
        return this.getLine().compareTo("0") != 0;
    }

    public byte[] getData() throws IOException {
        int n = this.getInteger();
        if (n <= 0) {
            return new byte[0];
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.is.read(byArray, n2, n - n2);
            if (n3 < 0) {
                throw new IOException();
            }
            n2 += n3;
        }
        return byArray;
    }

    public void getAck() throws Exception {
        String string = this.getString();
        if (string.compareTo("0") != 0) {
            String string2 = this.getString();
            if (string2.length() == 0) {
                string2 = "Unexpected error in acknowledgement";
            }
            throw new Exception("SwiffChart: " + string2);
        }
    }

    public void cmd_v_v(int n) throws Exception {
        this.putCmd(n);
        this.ps.flush();
        this.getAck();
    }

    public String cmd_v_s(int n) throws Exception {
        this.putCmd(n);
        this.ps.flush();
        String string = this.getString();
        this.getAck();
        return string;
    }

    public boolean cmd_v_b(int n) throws Exception {
        this.putCmd(n);
        this.ps.flush();
        boolean bl = this.getBool();
        this.getAck();
        return bl;
    }

    public void cmd_i_v(int n, int n2) throws Exception {
        this.putCmd(n);
        this.putInteger(n2);
        this.ps.flush();
        this.getAck();
    }

    public void cmd_s_v(int n, String string) throws Exception {
        this.putCmd(n);
        this.putString(string);
        this.ps.flush();
        this.getAck();
    }

    public int cmd_v_i(int n) throws Exception {
        this.putCmd(n);
        this.ps.flush();
        int n2 = this.getInteger();
        this.getAck();
        return n2;
    }

    public void cmd_b_v(int n, boolean bl) throws Exception {
        this.putCmd(n);
        this.putBool(bl);
        this.ps.flush();
        this.getAck();
    }

    public String cmd_i_s(int n, int n2) throws Exception {
        this.putCmd(n);
        this.putInteger(n2);
        this.ps.flush();
        String string = this.getString();
        this.getAck();
        return string;
    }

    public String cmd_is_s(int n, int n2, String string) throws Exception {
        this.putCmd(n);
        this.putInteger(n2);
        this.putString(string);
        this.ps.flush();
        String string2 = this.getString();
        this.getAck();
        return string2;
    }

    public void cmd_is_v(int n, int n2, String string) throws Exception {
        this.putCmd(n);
        this.putInteger(n2);
        this.putString(string);
        this.ps.flush();
        this.getAck();
    }

    public void cmd_iis_v(int n, int n2, int n3, String string) throws Exception {
        this.putCmd(n);
        this.putInteger(n2);
        this.putInteger(n3);
        this.putString(string);
        this.ps.flush();
        this.getAck();
    }

    public double cmd_ii_d(int n, int n2, int n3) throws Exception {
        this.putCmd(n);
        this.putInteger(n2);
        this.putInteger(n3);
        this.ps.flush();
        double d = this.getDouble();
        this.getAck();
        return d;
    }

    public void cmd_id_v(int n, int n2, double d) throws Exception {
        this.putCmd(n);
        this.putInteger(n2);
        this.putDouble(d);
        this.ps.flush();
        this.getAck();
    }

    public String GetVersion() throws Exception {
        return this.cmd_v_s(1);
    }

    public void LoadStyle(String string) throws Exception {
        this.cmd_s_v(2, string);
    }

    public void SetStyleData(String string) throws Exception {
        this.putCmd(3);
        this.putLine(string);
        this.ps.flush();
        this.getAck();
    }

    public void SetWidth(int n) throws Exception {
        this.cmd_i_v(4, n);
    }

    public int GetWidth() throws Exception {
        return this.cmd_v_i(5);
    }

    public void SetHeight(int n) throws Exception {
        this.cmd_i_v(6, n);
    }

    public int GetHeight() throws Exception {
        return this.cmd_v_i(7);
    }

    public void SetCompressed(boolean bl) throws Exception {
        this.cmd_b_v(8, bl);
    }

    public boolean IsCompressed() throws Exception {
        return this.cmd_v_b(9);
    }

    public void CompressSWF(boolean bl) throws Exception {
        this.SetCompressed(bl);
    }

    public boolean IsSWFCompressed() throws Exception {
        return this.IsCompressed();
    }

    public void AnimateChart(boolean bl) throws Exception {
        this.cmd_b_v(10, bl);
    }

    public boolean IsAnimated() throws Exception {
        return this.cmd_v_b(11);
    }

    public void SetFrameRate(int n) throws Exception {
        this.cmd_i_v(12, n);
    }

    public int GetFrameRate() throws Exception {
        return this.cmd_v_i(13);
    }

    public void SetLooping(boolean bl) throws Exception {
        this.cmd_b_v(14, bl);
    }

    public boolean IsLooping() throws Exception {
        return this.cmd_v_b(15);
    }

    public void ProtectSWF(boolean bl) throws Exception {
        this.cmd_b_v(16, bl);
    }

    public boolean IsSWFProtected() throws Exception {
        return this.cmd_v_b(17);
    }

    public void SetTitle(String string) throws Exception {
        this.cmd_s_v(18, string);
    }

    public String GetTitle() throws Exception {
        return this.cmd_v_s(19);
    }

    public void SetSubtitle(String string) throws Exception {
        this.cmd_s_v(20, string);
    }

    public String GetSubtitle() throws Exception {
        return this.cmd_v_s(21);
    }

    public void SetSeparators(String string, boolean bl) throws Exception {
        this.putCmd(22);
        this.putString(string);
        this.putBool(bl);
        this.ps.flush();
        this.getAck();
    }

    public String GetSeparators() throws Exception {
        return this.cmd_v_s(23);
    }

    public void SetLocaleInfo(int n, String string) throws Exception {
        this.cmd_is_v(24, n, string);
    }

    public void SetUnicode(boolean bl) throws Exception {
        this.cmd_b_v(25, bl);
    }

    public void SetDataFromTxtFile(String string, boolean bl, boolean bl2, boolean bl3) throws Exception {
        this.putCmd(26);
        this.putString(string);
        this.putBool(bl);
        this.putBool(bl2);
        this.putBool(bl3);
        this.ps.flush();
        this.getAck();
    }

    public void SetCategoriesFromString(String string) throws Exception {
        this.cmd_s_v(27, string);
    }

    public void SetCategoriesFromArray(String[] stringArray) throws Exception {
        this.putCmd(28);
        this.putArray(stringArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetCategory(int n, String string) throws Exception {
        this.cmd_is_v(29, n, string);
    }

    public String GetCategory(int n) throws Exception {
        return this.cmd_i_s(30, n);
    }

    public void ClearAll() throws Exception {
        this.cmd_v_v(31);
    }

    public void AddSeries() throws Exception {
        this.cmd_v_v(32);
    }

    public void SetSeriesCaptionsFromString(String string) throws Exception {
        this.cmd_s_v(33, string);
    }

    public void SetSeriesCaptionsFromArray(String[] stringArray) throws Exception {
        this.putCmd(34);
        this.putArray(stringArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesCaption(int n, String string) throws Exception {
        this.cmd_is_v(35, n, string);
    }

    public String GetSeriesCaption(int n) throws Exception {
        return this.cmd_i_s(36, n);
    }

    public int GetSeriesCount() throws Exception {
        return this.cmd_v_i(37);
    }

    public int GetValuesCount() throws Exception {
        return this.cmd_v_i(38);
    }

    public void SetSeriesXValuesFromString(int n, String string) throws Exception {
        this.cmd_is_v(39, n, string);
    }

    public void SetSeriesXValuesFromArray(int n, String[] stringArray) throws Exception {
        this.putCmd(40);
        this.putInteger(n);
        this.putArray(stringArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesXValuesFromArray(int n, int[] nArray) throws Exception {
        this.putCmd(40);
        this.putInteger(n);
        this.putArray(nArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesXValuesFromArray(int n, float[] fArray) throws Exception {
        this.putCmd(40);
        this.putInteger(n);
        this.putArray(fArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesXValuesFromArray(int n, double[] dArray) throws Exception {
        this.putCmd(40);
        this.putInteger(n);
        this.putArray(dArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesYValuesFromString(int n, String string) throws Exception {
        this.cmd_is_v(41, n, string);
    }

    public void SetSeriesYValuesFromArray(int n, String[] stringArray) throws Exception {
        this.putCmd(42);
        this.putInteger(n);
        this.putArray(stringArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesYValuesFromArray(int n, int[] nArray) throws Exception {
        this.putCmd(42);
        this.putInteger(n);
        this.putArray(nArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesYValuesFromArray(int n, float[] fArray) throws Exception {
        this.putCmd(42);
        this.putInteger(n);
        this.putArray(fArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesYValuesFromArray(int n, double[] dArray) throws Exception {
        this.putCmd(42);
        this.putInteger(n);
        this.putArray(dArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesZValuesFromString(int n, String string) throws Exception {
        this.cmd_is_v(69, n, string);
    }

    public void SetSeriesZValuesFromArray(int n, String[] stringArray) throws Exception {
        this.putCmd(70);
        this.putInteger(n);
        this.putArray(stringArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesZValuesFromArray(int n, int[] nArray) throws Exception {
        this.putCmd(70);
        this.putInteger(n);
        this.putArray(nArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesZValuesFromArray(int n, float[] fArray) throws Exception {
        this.putCmd(70);
        this.putInteger(n);
        this.putArray(fArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesZValuesFromArray(int n, double[] dArray) throws Exception {
        this.putCmd(70);
        this.putInteger(n);
        this.putArray(dArray);
        this.ps.flush();
        this.getAck();
    }

    public void SetSeriesValuesFromString(int n, String string) throws Exception {
        this.SetSeriesYValuesFromString(n, string);
    }

    public void SetSeriesValuesFromArray(int n, String[] stringArray) throws Exception {
        this.SetSeriesYValuesFromArray(n, stringArray);
    }

    public void SetSeriesValuesFromArray(int n, int[] nArray) throws Exception {
        this.SetSeriesYValuesFromArray(n, nArray);
    }

    public void SetSeriesValuesFromArray(int n, float[] fArray) throws Exception {
        this.SetSeriesYValuesFromArray(n, fArray);
    }

    public void SetSeriesValuesFromArray(int n, double[] dArray) throws Exception {
        this.SetSeriesYValuesFromArray(n, dArray);
    }

    public void SetSeriesXYValuesFromString(int n, String string) throws Exception {
        this.cmd_is_v(43, n, string);
    }

    public double GetSeriesXValue(int n, int n2) throws Exception {
        return this.cmd_ii_d(44, n, n2);
    }

    public double GetSeriesYValue(int n, int n2) throws Exception {
        return this.cmd_ii_d(45, n, n2);
    }

    public double GetSeriesValue(int n, int n2) throws Exception {
        return this.GetSeriesYValue(n, n2);
    }

    public void SetSeriesColor(int n, String string) throws Exception {
        this.cmd_is_v(72, n, string);
    }

    public void SetSeriesValueColor(int n, int n2, String string) throws Exception {
        this.cmd_iis_v(73, n, n2, string);
    }

    public void SetSeriesTrendlineColor(int n, String string) throws Exception {
        this.cmd_is_v(74, n, string);
    }

    public void SetAxisMinValue(int n, double d) throws Exception {
        this.cmd_id_v(46, n, d);
    }

    public void SetAxisMaxValue(int n, double d) throws Exception {
        this.cmd_id_v(47, n, d);
    }

    public void SetAxisCrossValue(int n, double d) throws Exception {
        this.cmd_id_v(48, n, d);
    }

    public void ResetAxisBounds(int n) throws Exception {
        this.cmd_i_v(49, n);
    }

    public void SetAxisTitle(int n, String string) throws Exception {
        this.cmd_is_v(50, n, string);
    }

    public String GetAxisTitle(int n) throws Exception {
        return this.cmd_i_s(51, n);
    }

    public void SetOutputFormat(String string) throws Exception {
        this.cmd_s_v(52, string);
    }

    public void SetJPGQuality(int n) throws Exception {
        this.cmd_i_v(53, n);
    }

    public void SetPNGCompLevel(int n) throws Exception {
        this.cmd_i_v(54, n);
    }

    public byte[] ExportAsBinary() throws Exception {
        this.putCmd(55);
        this.ps.flush();
        byte[] byArray = this.getData();
        this.getAck();
        return byArray;
    }

    public void ExportAsFile(String string) throws Exception {
        this.cmd_s_v(56, string);
    }

    public void SetDocumentRoot(String string) throws Exception {
        this.cmd_s_v(57, string);
    }

    public void SetAppRootUrl(String string) throws Exception {
        this.cmd_s_v(75, string);
    }

    public String GetHTMLTag() throws Exception {
        return this.cmd_v_s(58);
    }

    public String GetOutputLocation() throws Exception {
        return this.cmd_v_s(59);
    }

    public String GetHTTPContentType() throws Exception {
        return this.cmd_v_s(60);
    }

    public void ClearCache() throws Exception {
        this.cmd_v_v(61);
    }

    public void SetCacheName(String string) throws Exception {
        this.cmd_s_v(62, string);
    }

    public void SetPrivateCacheDir(String string) throws Exception {
        this.cmd_s_v(63, string);
    }

    public void SetMaxCacheSize(int n) throws Exception {
        this.cmd_i_v(64, n);
    }

    public void UseCache(boolean bl) throws Exception {
        this.cmd_b_v(65, bl);
    }

    public void SetTTFontsDir(String string) throws Exception {
        this.cmd_s_v(66, string);
    }

    public void BatchCommands(String string) throws Exception {
        this.putCmd(67);
        this.putData(string);
        this.ps.flush();
        this.getAck();
    }

    public void SetDebugMode(int n) throws Exception {
        this.cmd_i_v(68, n);
    }
}

