/*
 * Decompiled with CFR 0.152.
 */
package com.globfx.swiffchart;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class SwiffChart {
    protected int width;
    protected int height;
    protected int frame_rate;
    protected boolean animate;
    protected boolean looping;
    protected boolean has_looping;
    protected boolean swf_compressed;
    protected boolean swf_protected;
    protected String separators;
    protected boolean ignore_multiple_sep;
    protected char decimal_sep;
    protected char thousands_sep;
    protected String install_dir = "C:/Program Files/GlobFX Technologies/Swiff Chart Generator";
    protected String style;
    protected String title;
    protected String subtitle;
    protected String[] categs;
    protected Vector series_captions;
    protected Vector series_x_values;
    protected Vector series_y_values;
    protected String[] axis_min_value;
    protected String[] axis_max_value;
    protected String[] axis_cross_value;
    protected String[] axis_title;
    protected String cache_name = "";
    protected String private_cache_dir = "";
    protected int max_cache_size = -1;
    protected String fonts_dir_list = "";
    protected boolean use_cache = false;
    protected int output_format = 0;
    protected int jpg_quality = 75;
    protected int png_comp_level = 3;
    protected String document_root = "";
    protected boolean no_cache = true;
    public String shell_exec_error = "";
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    String so = " /";
    String lo = " /";
    protected static String hexchars = "0123456789ABCDEF";

    public SwiffChart() {
        this.ClearAll();
    }

    public void Release() {
        this.request = null;
        this.response = null;
    }

    public void ClearAll() {
        this.width = 0;
        this.height = 0;
        this.frame_rate = 0;
        this.animate = true;
        this.looping = true;
        this.has_looping = false;
        this.swf_compressed = false;
        this.swf_protected = true;
        this.separators = ";";
        this.ignore_multiple_sep = false;
        this.decimal_sep = '\u0000';
        this.thousands_sep = '\u0000';
        this.style = "";
        this.title = null;
        this.subtitle = null;
        this.categs = new String[0];
        this.series_captions = new Vector();
        this.series_x_values = new Vector();
        this.series_y_values = new Vector();
        this.axis_min_value = new String[4];
        this.axis_max_value = new String[4];
        this.axis_cross_value = new String[4];
        this.axis_title = new String[4];
    }

    public void SetWidth(int n) {
        this.width = n;
    }

    public void SetHeight(int n) {
        this.height = n;
    }

    public int GetWidth() {
        return this.width;
    }

    public int GetHeight() {
        return this.height;
    }

    public void SetFrameRate(int n) {
        this.frame_rate = n;
    }

    public int GetFrameRate() {
        return this.frame_rate;
    }

    public void AnimateChart(boolean bl) {
        this.animate = bl;
    }

    public boolean IsAnimated() {
        return this.animate;
    }

    public void SetLooping(boolean bl) {
        this.looping = bl;
        this.has_looping = true;
    }

    public boolean GetLooping() {
        return this.has_looping ? this.looping : true;
    }

    public void CompressSWF(boolean bl) {
        this.swf_compressed = bl;
    }

    public boolean IsSWFCompressed() {
        return this.swf_compressed;
    }

    public void ProtectSWF(boolean bl) {
        this.swf_protected = bl;
    }

    public boolean IsSWFProtected() {
        return this.swf_protected;
    }

    public void SetSeparators(String string, boolean bl) {
        if (string == "") {
            string = ";";
        }
        this.separators = string;
        this.ignore_multiple_sep = bl;
    }

    public String GetSeparators() {
        return this.separators;
    }

    public void SetLocaleInfo(int n, char c) throws ServletException {
        switch (n) {
            case 1: {
                this.decimal_sep = c;
                break;
            }
            case 2: {
                this.thousands_sep = c;
                break;
            }
            default: {
                throw new ServletException("SwiffChart: SetLocaleInfo(): invalid type (" + n + ")");
            }
        }
    }

    public void SetTitle(String string) {
        this.title = string;
    }

    public String GetTitle() {
        return this.title;
    }

    public void SetSubtitle(String string) {
        this.subtitle = string;
    }

    public String GetSubtitle() {
        return this.subtitle;
    }

    public void SetCategoriesFromArray(String[] stringArray) {
        this.categs = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            this.categs[n] = stringArray[n];
            ++n;
        }
    }

    protected int strpbrk(String string, int n, String string2) {
        int n2 = -1;
        int n3 = 0;
        while (n3 < string2.length()) {
            int n4 = string.indexOf(string2.charAt(n3), n);
            if (n4 != -1) {
                if (n2 == -1) {
                    n2 = n4;
                } else if (n4 < n2) {
                    n2 = n4;
                }
            }
            ++n3;
        }
        return n2;
    }

    protected String[] split_string(String string, String string2, boolean bl) {
        String[] stringArray = new String[]{};
        int n = 0;
        while (true) {
            int n2;
            int n3;
            int n4 = n3 = (n2 = this.strpbrk(string, n, string2)) == -1 ? string.length() : n2;
            if (n > 0 && n2 != -1 && n3 == n && bl) {
                if (n2 == -1) break;
                ++n;
                continue;
            }
            String string3 = string.substring(n, n3);
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
            stringArray[stringArray.length - 1] = string3;
            if (n2 == -1) break;
            n = n3 + 1;
        }
        return stringArray;
    }

    public void SetCategoriesFromString(String string) {
        this.SetCategoriesFromArray(this.split_string(string, this.separators, this.ignore_multiple_sep));
    }

    public String GetCategory(int n) throws ServletException {
        if (n < 0 || n >= this.categs.length) {
            throw new ServletException("SwiffChart: GetCategory(): index " + n + " is out of bounds [0," + this.categs.length + "]");
        }
        return this.categs[n];
    }

    public void SetSeriesCaptionsFromArray(String[] stringArray) {
        this.series_captions = new Vector(stringArray.length);
        this.series_captions.setSize(stringArray.length);
        int n = 0;
        while (n < stringArray.length) {
            this.series_captions.setElementAt(stringArray[n], n);
            ++n;
        }
        while (this.GetSeriesCount() < this.series_captions.size()) {
            this.AddSeries();
        }
    }

    public void SetSeriesCaptionsFromString(String string) {
        this.SetSeriesCaptionsFromArray(this.split_string(string, this.separators, this.ignore_multiple_sep));
    }

    public void SetSeriesCaption(int n, String string) throws ServletException {
        if (n < 0 || n >= this.GetSeriesCount()) {
            throw new ServletException("SwiffChart: SetSeriesCaption(): index " + n + " is out of bounds [0," + (this.GetSeriesCount() - 1) + "]");
        }
        this.series_captions.setElementAt(string, n);
    }

    public String GetSeriesCaption(int n) throws ServletException {
        if (n < 0 || n >= this.GetSeriesCount()) {
            throw new ServletException("SwiffChart: GetSeriesCaption(): index " + n + " is out of bounds [0," + (this.GetSeriesCount() - 1) + "]");
        }
        return (String)this.series_captions.elementAt(n);
    }

    public void AddSeries() {
        this.series_y_values.addElement(new String[0]);
        this.series_x_values.addElement(new String[0]);
        this.series_captions.addElement(new String());
    }

    public int GetValuesCount() {
        int n = this.categs.length;
        int n2 = 0;
        while (n2 < this.series_y_values.size()) {
            String[] stringArray = (String[])this.series_y_values.elementAt(n2);
            if (stringArray.length > n) {
                n = stringArray.length;
            }
            if ((stringArray = (String[])this.series_x_values.elementAt(n2)).length > n) {
                n = stringArray.length;
            }
            ++n2;
        }
        return n;
    }

    public int GetSeriesCount() {
        return this.series_y_values.size();
    }

    public String GetSeriesValue(int n, int n2) throws ServletException {
        return this.GetSeriesYValue(n, n2);
    }

    public String GetSeriesXValue(int n, int n2) throws ServletException {
        if (n < 0 || n >= this.GetSeriesCount()) {
            throw new ServletException("SwiffChart: GetSeriesXValue(): index " + n + " is out of bounds [0," + (this.GetSeriesCount() - 1) + "]");
        }
        String[] stringArray = (String[])this.series_x_values.elementAt(n);
        if (n2 < 0 || n2 >= stringArray.length) {
            throw new ServletException("SwiffChart: GetSeriesXValue(): value index " + n2 + " is out of bounds [0," + (stringArray.length - 1) + "]");
        }
        return stringArray[n2];
    }

    public String GetSeriesYValue(int n, int n2) throws ServletException {
        if (n < 0 || n >= this.GetSeriesCount()) {
            throw new ServletException("SwiffChart: GetSeriesYValue(): index " + n + " is out of bounds [0," + (this.GetSeriesCount() - 1) + "]");
        }
        String[] stringArray = (String[])this.series_y_values.elementAt(n);
        if (n2 < 0 || n2 >= stringArray.length) {
            throw new ServletException("SwiffChart: GetSeriesYValue(): value index " + n2 + " is out of bounds [0," + (stringArray.length - 1) + "]");
        }
        return stringArray[n2];
    }

    public void SetSeriesValuesFromArray(int n, String[] stringArray) throws ServletException {
        this.SetSeriesYValuesFromArray(n, stringArray);
    }

    public void SetSeriesValuesFromString(int n, String string) throws ServletException {
        this.SetSeriesYValuesFromString(n, string);
    }

    public void SetSeriesXValuesFromArray(int n, String[] stringArray) throws ServletException {
        if (n < 0 || n >= this.GetSeriesCount()) {
            throw new ServletException("SwiffChart: SetSeriesXValuesFromArray(): index " + n + " is out of bounds [0," + (this.GetSeriesCount() - 1) + "]");
        }
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        this.series_x_values.setElementAt(stringArray2, n);
    }

    public void SetSeriesXValuesFromString(int n, String string) throws ServletException {
        this.SetSeriesXValuesFromArray(n, this.split_string(string, this.separators, this.ignore_multiple_sep));
    }

    public void SetSeriesYValuesFromArray(int n, String[] stringArray) throws ServletException {
        if (n < 0 || n >= this.GetSeriesCount()) {
            throw new ServletException("SwiffChart: SetSeriesYValuesFromArray(): index " + n + " is out of bounds [0," + (this.GetSeriesCount() - 1) + "]");
        }
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2] = stringArray[n2];
            ++n2;
        }
        this.series_y_values.setElementAt(stringArray2, n);
    }

    public void SetSeriesYValuesFromString(int n, String string) throws ServletException {
        this.SetSeriesYValuesFromArray(n, this.split_string(string, this.separators, this.ignore_multiple_sep));
    }

    public void SetSeriesXYValuesFromString(int n, String string) throws ServletException {
        if (n < 0 || n >= this.GetSeriesCount()) {
            throw new ServletException("SwiffChart: SetSeriesXYValuesFromString(): index " + n + " is out of bounds [0," + (this.GetSeriesCount() - 1) + "]");
        }
        String[] stringArray = this.split_string(string, this.separators, this.ignore_multiple_sep);
        int n2 = stringArray.length / 2;
        String[] stringArray2 = new String[stringArray.length];
        String[] stringArray3 = new String[stringArray.length];
        this.series_x_values.setElementAt(stringArray2, n);
        this.series_y_values.setElementAt(stringArray3, n);
        int n3 = 0;
        while (n3 < n2) {
            stringArray2[n3] = stringArray[2 * n3];
            stringArray3[n3] = stringArray[2 * n3 + 1];
            ++n3;
        }
    }

    public void SetAxisMinValue(int n, String string) throws ServletException {
        if (n < 0 || n > 3) {
            throw new ServletException("SwiffChart: SetAxisMinValue(): axis number " + n + " is out of bounds [0,1]");
        }
        this.axis_min_value[n] = string;
    }

    public void SetAxisMaxValue(int n, String string) throws ServletException {
        if (n < 0 || n > 3) {
            throw new ServletException("SwiffChart: SetAxisMaxValue(): axis number " + n + " is out of bounds [0,1]");
        }
        this.axis_max_value[n] = string;
    }

    public void SetAxisCrossValue(int n, String string) throws ServletException {
        if (n < 0 || n > 3) {
            throw new ServletException("SwiffChart: SetAxisCrossValue(): axis number " + n + " is out of bounds [0,1]");
        }
        this.axis_cross_value[n] = string;
    }

    public void ResetAxisBounds(int n) throws ServletException {
        if (n < 0 || n > 3) {
            throw new ServletException("SwiffChart: ResetAxisBounds(): axis number " + n + " is out of bounds [0,1]");
        }
        this.axis_min_value[n] = null;
        this.axis_max_value[n] = null;
        this.axis_cross_value[n] = null;
    }

    public void SetAxisTitle(int n, String string) throws ServletException {
        if (n < 0 || n > 3) {
            throw new ServletException("SwiffChart: SetAxisTitle(): axis number " + n + " is out of bounds [0,1]");
        }
        this.axis_title[n] = string;
    }

    public String GetAxisTitle(int n) throws ServletException {
        if (n < 0 || n > 3) {
            throw new ServletException("SwiffChart: GetAxisTitle(): axis number " + n + " is out of bounds [0,1]");
        }
        return this.axis_title[n];
    }

    public void SetDataFromQuery() throws ServletException {
        throw new ServletException("SwiffChart: SetDataFromQuery(): Not implemented");
    }

    public void SetDataFromTxtFile(String string, boolean bl, boolean bl2, boolean bl3) throws ServletException {
        throw new ServletException("SwiffChart: SetDataFromTxtFile(): Not implemented");
    }

    public void SetXYDataFromTxtFile(String string, boolean bl, boolean bl2, boolean bl3) throws ServletException {
        throw new ServletException("SwiffChart: SetXYDataFromTxtFile(): Not implemented");
    }

    protected String rawurlencode(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(3 * string.length());
        int n = 0;
        while (n < string.length()) {
            int n2 = string.charAt(n);
            if (n2 < 48 && n2 != 46 || n2 < 65 && n2 > 57 || n2 > 90 && n2 < 97 && n2 != 95 || n2 > 122) {
                if (n2 < 256) {
                    stringBuffer.append('%');
                    stringBuffer.append(hexchars.charAt((n2 &= 0xFF) >> 4));
                    stringBuffer.append(hexchars.charAt(n2 & 0xF));
                } else {
                    stringBuffer.append('@');
                    stringBuffer.append(hexchars.charAt((n2 &= 0xFFFF) >> 12 & 0xF));
                    stringBuffer.append(hexchars.charAt(n2 >> 8 & 0xF));
                    stringBuffer.append(hexchars.charAt(n2 >> 4 & 0xF));
                    stringBuffer.append(hexchars.charAt(n2 & 0xF));
                }
            } else {
                stringBuffer.append((char)n2);
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    protected String rawurldecode(String string) {
        if (string == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c != '%' || n + 3 >= string.length()) {
                stringBuffer.append(c);
            } else {
                int n2 = string.charAt(n + 1);
                int n3 = string.charAt(n + 2);
                if (n2 >= 97 && n2 <= 122) {
                    n2 -= 32;
                }
                if (n3 >= 97 && n3 <= 122) {
                    n3 -= 32;
                }
                int n4 = n2 >= 65 ? n2 - 65 + 10 << 4 : n2 - 48 << 4;
                n4 = n3 >= 65 ? (n4 += n3 - 65 + 10) : (n4 += n3 - 48);
                stringBuffer.append((char)n4);
                n += 2;
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    protected String mangle(String string) {
        return this.rawurlencode(string);
    }

    protected String mangle_int(int n) {
        return this.mangle(Integer.toString(n));
    }

    protected String mangle_char(char c) {
        return this.mangle(new Character(c).toString());
    }

    protected String prepare_cmd_line(boolean bl, boolean bl2) {
        int n;
        StringBuffer stringBuffer;
        int n2;
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(this.install_dir + "/swfchart");
        if (this.style != null && this.style != "") {
            stringBuffer2.append(this.so + "s " + this.mangle(this.style));
        }
        if (this.width >= 1) {
            stringBuffer2.append(this.lo + "width " + this.mangle_int(this.width));
        }
        if (this.height >= 1) {
            stringBuffer2.append(this.lo + "height " + this.mangle_int(this.height));
        }
        if (this.frame_rate >= 1) {
            stringBuffer2.append(this.lo + "fps " + this.mangle_int(this.frame_rate));
        }
        if (!this.animate) {
            stringBuffer2.append(this.so + "a false");
        }
        if (!this.swf_protected) {
            stringBuffer2.append(this.lo + "protect false");
        }
        if (this.swf_compressed) {
            stringBuffer2.append(this.lo + "compress true");
        }
        if (this.has_looping) {
            stringBuffer2.append(this.lo + "looping " + (this.looping ? "true" : "false"));
        }
        stringBuffer2.append(this.so + "tr false" + this.so + "tc false" + this.so + "sr");
        if (this.title != null && this.title != "") {
            stringBuffer2.append(this.lo + "title " + this.mangle(this.title));
        }
        if (this.subtitle != null && this.subtitle != "") {
            stringBuffer2.append(this.lo + "subtitle " + this.mangle(this.subtitle));
        }
        if (this.decimal_sep != '\u0000') {
            stringBuffer2.append(this.so + "ds " + this.mangle_char(this.decimal_sep));
        }
        if (this.thousands_sep != '\u0000') {
            stringBuffer2.append(this.so + "ts " + this.mangle_char(this.thousands_sep));
        }
        if ((n2 = this.categs.length) > 0) {
            stringBuffer = new StringBuffer();
            n = 0;
            while (n < n2) {
                if (n > 0) {
                    stringBuffer.append(this.separators.charAt(0));
                }
                stringBuffer.append(this.categs[n]);
                ++n;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer2.append(this.so + "c " + this.mangle(stringBuffer.toString()));
            }
        }
        if ((n2 = this.series_captions.size()) > 0) {
            stringBuffer = new StringBuffer();
            n = 0;
            while (n < n2) {
                Object e;
                if (n > 0) {
                    stringBuffer.append(this.separators.charAt(0));
                }
                if ((e = this.series_captions.elementAt(n)) != null) {
                    stringBuffer.append((String)e);
                }
                ++n;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer2.append(this.so + "i " + this.mangle(stringBuffer.toString()));
            }
        }
        if ((n2 = this.series_y_values.size()) > 0) {
            String[] stringArray;
            stringBuffer = new StringBuffer();
            boolean bl3 = false;
            n = 0;
            while (n < n2) {
                stringArray = (String[])this.series_x_values.elementAt(n);
                if (stringArray.length > 0) {
                    bl3 = true;
                    break;
                }
                ++n;
            }
            n = 0;
            while (n < n2) {
                int n3;
                if (bl3) {
                    stringArray = (String[])this.series_x_values.elementAt(n);
                    n3 = 0;
                    while (n3 < stringArray.length) {
                        if (n3 > 0) {
                            stringBuffer.append(this.separators.charAt(0));
                        }
                        stringBuffer.append(stringArray[n3]);
                        ++n3;
                    }
                    stringBuffer.append("\\n");
                }
                stringArray = (String[])this.series_y_values.elementAt(n);
                n3 = 0;
                while (n3 < stringArray.length) {
                    if (n3 > 0) {
                        stringBuffer.append(this.separators.charAt(0));
                    }
                    stringBuffer.append(stringArray[n3]);
                    ++n3;
                }
                if (n + 1 < n2) {
                    stringBuffer.append("\\n");
                }
                ++n;
            }
            if (stringBuffer.length() > 0) {
                stringBuffer2.append(this.so + "n " + this.mangle(stringBuffer.toString()));
            }
        }
        if (this.axis_title[0] != null && this.axis_title[0] != "") {
            stringBuffer2.append(this.lo + "haxis-title " + this.mangle(this.axis_title[0]));
        }
        if (this.axis_title[1] != null && this.axis_title[1] != "") {
            stringBuffer2.append(this.lo + "vaxis-title " + this.mangle(this.axis_title[1]));
        }
        if (this.axis_min_value[0] != null && this.axis_min_value[0] != "") {
            stringBuffer2.append(this.lo + "axis-min 0 " + this.mangle(this.axis_min_value[0]));
        }
        if (this.axis_min_value[1] != null && this.axis_min_value[1] != "") {
            stringBuffer2.append(this.lo + "axis-min 1 " + this.mangle(this.axis_min_value[1]));
        }
        if (this.axis_max_value[0] != null && this.axis_max_value[0] != "") {
            stringBuffer2.append(this.lo + "axis-max 0 " + this.mangle(this.axis_max_value[0]));
        }
        if (this.axis_max_value[1] != null && this.axis_max_value[1] != "") {
            stringBuffer2.append(this.lo + "axis-max 1 " + this.mangle(this.axis_max_value[1]));
        }
        if (this.axis_cross_value[0] != null && this.axis_cross_value[0] != "") {
            stringBuffer2.append(this.lo + "axis-cross 0 " + this.mangle(this.axis_cross_value[0]));
        }
        if (this.axis_cross_value[1] != null && this.axis_cross_value[1] != "") {
            stringBuffer2.append(this.lo + "axis-cross 1 " + this.mangle(this.axis_cross_value[1]));
        }
        if (this.separators.charAt(0) != ';') {
            stringBuffer2.append(this.so + "d '" + this.mangle_char(this.separators.charAt(0)) + "'");
        }
        if (bl || bl2 || this.use_cache) {
            if (bl) {
                stringBuffer2.append(this.lo + "html-tag");
            } else if (bl2) {
                stringBuffer2.append(this.lo + "output-loc");
            } else {
                stringBuffer2.append(this.lo + "use-cache");
            }
            if (this.document_root != null && this.document_root != "") {
                stringBuffer2.append(this.lo + "doc-root " + this.mangle(this.document_root));
            }
            if (this.cache_name != null && this.cache_name != "") {
                stringBuffer2.append(this.lo + "cache-name " + this.mangle(this.cache_name));
            }
            if (this.private_cache_dir != null && this.private_cache_dir != "") {
                stringBuffer2.append(this.lo + "private-cache-dir " + this.mangle(this.private_cache_dir));
            }
            if (this.max_cache_size >= 0) {
                stringBuffer2.append(this.lo + "max-cache-size " + this.max_cache_size);
            }
        }
        if (this.fonts_dir_list != null && this.fonts_dir_list != "") {
            stringBuffer2.append(this.lo + "fonts " + this.mangle(this.fonts_dir_list));
        }
        if (this.output_format == 1) {
            stringBuffer2.append(this.lo + "format jpg");
            if (this.jpg_quality != 75) {
                stringBuffer2.append(this.lo + "jpg-quality " + this.jpg_quality);
            }
        } else if (this.output_format == 2) {
            stringBuffer2.append(this.lo + "format png");
            if (this.png_comp_level != 3) {
                stringBuffer2.append(this.lo + "png-comp-level " + this.png_comp_level);
            }
        }
        return stringBuffer2.toString();
    }

    protected byte[] read_stream(InputStream inputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8192];
        int n2 = 0;
        while ((n = inputStream.read(byArray, n2, byArray.length - n2)) > 0) {
            if ((n2 += n) < byArray.length) continue;
            int n3 = byArray.length + byArray.length / 2;
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, n2);
        byArray = byArray3;
        return byArray;
    }

    public byte[] shell_exec(String string) throws IOException {
        this.shell_exec_error = "";
        Runtime runtime = Runtime.getRuntime();
        Process process = runtime.exec(string);
        InputStream inputStream = process.getInputStream();
        byte[] byArray = this.read_stream(inputStream);
        if (byArray.length > 0) {
            return byArray;
        }
        byArray = this.read_stream(process.getErrorStream());
        this.shell_exec_error = new String(byArray);
        return null;
    }

    public void SetCacheName(String string) {
        this.cache_name = string;
    }

    public void SetPrivateCacheDir(String string) {
    }

    public void SetMaxCacheSize(int n) {
        this.max_cache_size = n;
    }

    public void ClearCache() throws ServletException, IOException {
        String string = this.prepare_cmd_line(true, false);
        string = string + this.lo + "clear-cache";
        this.shell_exec(string);
        if (this.shell_exec_error.length() > 0) {
            throw new ServletException("SwiffChart: ClearCache(): An error occurred: " + this.shell_exec_error);
        }
    }

    public void UseCache(boolean bl) {
        this.use_cache = bl;
    }

    public void SetTTFontsDir(String string) {
        this.fonts_dir_list = string;
    }

    public void SetOutputFormat(String string) throws ServletException {
        String string2 = string.toLowerCase();
        if (string2.compareTo("swf") == 0) {
            this.output_format = 0;
            return;
        }
        if (string2.compareTo("jpg") == 0) {
            this.output_format = 1;
            return;
        }
        if (string2.compareTo("png") == 0) {
            this.output_format = 2;
            return;
        }
        throw new ServletException("SwiffChart: SetOutputFormat(): Invalid output format '" + string + "'");
    }

    public String GetHTTPContentType() {
        switch (this.output_format) {
            case 0: {
                return "application/x-shockwave-flash";
            }
            case 1: {
                return "image/jpeg";
            }
            case 2: {
                return "image/png";
            }
        }
        return "";
    }

    public void ExportAsResponse() throws ServletException, IOException {
        if (this.response == null) {
            throw new ServletException("SwiffChart: ExportAsResponse(): SetServletInfo() has not been called");
        }
        String string = this.prepare_cmd_line(false, false);
        byte[] byArray = this.shell_exec(string);
        if (this.shell_exec_error.length() > 0) {
            throw new ServletException("SwiffChart: ExportAsResponse(): An error occurred: " + this.shell_exec_error);
        }
        this.response.reset();
        this.response.setContentType(this.GetHTTPContentType());
        if (this.no_cache) {
            this.response.addHeader("Expires", "Mon, 01 Jan 1990 00:00:00 GMT");
            this.response.addHeader("Pragma", "no-cache");
        }
        ServletOutputStream servletOutputStream = this.response.getOutputStream();
        servletOutputStream.write(byArray, 0, byArray.length);
    }

    public byte[] ExportAsBinary() throws ServletException, IOException {
        String string = this.prepare_cmd_line(false, false);
        byte[] byArray = this.shell_exec(string);
        if (this.shell_exec_error.length() > 0) {
            throw new ServletException("SwiffChart: ExportAsBinary(): An error occurred: " + this.shell_exec_error);
        }
        return byArray;
    }

    public void ExportAsFile(String string) throws ServletException, IOException {
        String string2 = this.prepare_cmd_line(false, false);
        string2 = string2 + this.so + "o " + this.mangle(string);
        this.shell_exec(string2);
        if (this.shell_exec_error.length() > 0) {
            throw new ServletException("SwiffChart: ExportAsFile(): An error occurred: " + this.shell_exec_error);
        }
    }

    public void SetJPGQuality(int n) {
        this.jpg_quality = n;
    }

    public void SetPNGCompLevel(int n) {
        this.png_comp_level = n;
    }

    public String GetHTMLTag() throws ServletException, IOException {
        String string = this.prepare_cmd_line(true, false);
        byte[] byArray = this.shell_exec(string);
        if (this.shell_exec_error.length() > 0) {
            throw new ServletException("SwiffChart: GetHTMLTag(): An error occurred: " + this.shell_exec_error);
        }
        return new String(byArray);
    }

    public String GetOutputLocation() throws ServletException, IOException {
        String string = this.prepare_cmd_line(false, true);
        byte[] byArray = this.shell_exec(string);
        if (this.shell_exec_error.length() > 0) {
            throw new ServletException("SwiffChart: GetOutputLocation(): An error occurred: " + this.shell_exec_error);
        }
        return new String(byArray);
    }

    protected int substr_count(String string, char c) {
        int n;
        int n2 = 0;
        int n3 = 0;
        while ((n = string.indexOf(c, n3)) != -1) {
            ++n2;
            n3 = n + 1;
        }
        return n2;
    }

    public void LoadStyle(String string) throws ServletException {
        if (this.substr_count(string, '/') == 0 || string.charAt(0) != '/') {
            string = this.install_dir + "/styles/" + string;
        }
        if (new File(string).getName().indexOf(".scs") == -1) {
            string = string + ".scs";
        }
        if (!new File(string).canRead()) {
            throw new ServletException("SwiffChart: Unable to open file " + string);
        }
        this.style = string;
    }

    public String GetVersion() throws ServletException, IOException {
        String string = this.install_dir + "/swfchart";
        String string2 = string + this.so + "rawversion";
        byte[] byArray = this.shell_exec(string2);
        if (this.shell_exec_error.length() > 0) {
            throw new ServletException("SwiffChart: GetVersion(): An error occurred: " + this.shell_exec_error);
        }
        return new String(byArray);
    }

    public void SetInstallDir(String string) {
        this.install_dir = string;
    }

    public void SetDocumentRoot(String string) {
        this.document_root = string;
    }

    public void SetServletInfo(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        this.request = httpServletRequest;
        this.response = httpServletResponse;
    }
}

