<?php

class SwiffChart
{
  var $com;

  function SwiffChart()
    {
    $this->com= new COM("SwiffChartObject.ChartObj") or die("Unable to instantiate Swiff Chart Object");
    }

  function Release()
    {
    return $this->com->Release();
    }

  function AddSeries()
    {
    $this->com->AddSeries();
    }

  function AnimateChart($animate)
    {
    $this->com->AnimateChart($animate);
    }

  function ClearAll()
    {
    $this->com->ClearAll();
    }

  function CompressSWF($swf_compressed)
    {
    $this->com->CompressSWF($swf_compressed);
    }

  function ExportAsBase64()
    {
    return $this->com->ExportAsBase64();
    }

  function ExportAsBinary()
    {
    return base64_decode($this->com->ExportAsBase64());
    }

  function ExportAsFile($filename)
    {
    $this->com->ExportAsFile($filename);
    }

  function ExportAsResponse()
    {
    Header("Content-Type: application/x-shockwave-flash");
    Header("Expires: 0"); 
    echo $this->ExportAsBinary();
    }

  function GetCategory($index)
    {
    return $this->com->GetCategory($index);
    }

  function GetFrameRate()
    {
    return $this->com->GetFrameRate();
    }

  function GetHeight()
    {
    return $this->com->GetHeight();
    }

  function GetSeparators()
    {
    return $this->com->GetSeparators();
    }

  function GetSeriesCaption($index)
    {
    return $this->com->GetSeriesCaption($index);
    }

  function GetSeriesCount()
    {
    return $this->com->GetSeriesCount();
    }

  function GetSeriesValue($index,$valueindex)
    {
    return $this->com->GetSeriesValue($index,$valueindex);
    }

  function GetSeriesXValue($index,$valueindex)
    {
    return $this->com->GetSeriesXValue($index,$valueindex);
    }

  function GetSeriesYValue($index,$valueindex)
    {
    return $this->com->GetSeriesYValue($index,$valueindex);
    }

  function GetSubtitle()
    {
    return $this->com->GetSubtitle();
    }

  function GetTitle()
    {
    return $this->com->GetTitle();
    }

  function GetValuesCount()
    {
    return $this->com->GetValuesCount();
    }

  function GetVersion()
    {
    return $this->com->GetVersion();
    }

  function GetWidth()
    {
    return $this->com->GetWidth();
    }

  function IsAnimated()
    {
    return $this->com->IsAnimated();
    }

  function IsSWFCompressed()
    {
    return $this->com->IsSWFCompressed();
    }

  function IsSWFProtected()
    {
    return $this->com->IsSWFProtected();
    }

  function LoadStyle($style_name)
    {
    $this->com->LoadStyle($style_name);
    }

  function ProtectSWF($swf_protected)
    {
    $this->com->ProtectSWF($swf_protected);
    }

  function SetCategoriesFromArray($array)
    {
    $this->com->SetCategoriesFromArray($array);
    }

  function SetCategoriesFromString($categories)
    {
    $this->com->SetCategoriesFromString($categories);
    }

  function SetDataFromQuery()
    {
    if( array_key_exists("QUERY_STRING", $_SERVER)) 
      $qs= $_SERVER["QUERY_STRING"];
     else
      $qs= "";

    $n_series=0;
    $qa= split("&",$qs);
    foreach($qa as $vv)
      {
      $vv2= split("=",$vv);
      if( count($vv2) >= 2 )
        list($var,$val)= $vv2;
       else
        {
        $var= $vv2[0];
        $val= "";
        }

      $var= urldecode($var);
      $val= urldecode($val);

      if( strcasecmp($var,"animate") == 0 )
        {
        $animate= ($val == "0" ||
                   strcasecmp($val,"no") == 0 ||
                   strcasecmp($val,"false") == 0) ? false : true;
        $this->AnimateChart($animate);
        continue;
        }

      if( strcasecmp($var,"width") == 0 )
        {
        $this->SetWidth($val);
        continue;
        }

      if( strcasecmp($var,"height") == 0 )
        {
        $this->SetHeight($val);
        continue;
        }

      if( strcasecmp($var,"fps") == 0 )
        {
        $this->SetFrameRate($val);
        continue;
        }

      if( strcasecmp($var,"title") == 0 )
        {
        $this->SetTitle($val);
        continue;
        }

      if( strcasecmp($var,"categories") == 0 )
        {
        $this->SetCategoriesFromString($val);
        continue;
        }

      if( strcasecmp($var,"captions") == 0 )
        {
        $this->SetSeriesCaptionsFromString($val);
        continue;
        }

      if( preg_match("/^seriesxy/i",$var) )
        {
        $sep= $this->GetSeparators();
        $sva= split( '['.$sep.']' ,$val);
        $series_values= "";
        for( $i= 0; $i < count($sva); ++$i )
          $series_values .= (($i==0) ? "" : $sep[0]) . $sva[$i];

        $this->AddSeries();
        $this->SetSeriesXYValuesFromString($n_series,$series_values);
        $n_series++;
        continue;
        }

      if( preg_match("/^series/i",$var) )
        {
        $sep= $this->GetSeparators();
        $sva= split( '['.$sep.']' ,$val);
        $series_values= "";
        for( $i= 0; $i < count($sva); ++$i )
          $series_values .= (($i==0) ? "" : $sep[0]) . $sva[$i];

        $this->AddSeries();
        $this->SetSeriesValuesFromString($n_series,$series_values);
        $n_series++;
        continue;
        }
      }
    }

  function SetDataFromTxtFile($filename, $seriesincolumn, $titlesinfirstrow, $titlesinfirstcolumn)
    {
    $this->com->SetDataFromTxtFile($filename,$seriesincolumn,$titlesinfirstrow,$titlesinfirstcolumn);
    }

  function SetFrameRate($framerate)
    {
    $this->com->SetFrameRate($framerate);
    }

  function SetHeight($height)
    {
    $this->com->SetHeight($height);
    }

  function SetLooping($looping)
    {
    $this->com->SetLooping($looping);
    }

  function SetSeparators($separators, $ignoremultseparators)
    {
    $this->com->SetSeparators($separators,$ignoremultseparators);
    }

  function SetSeriesCaption($index, $caption)
    {
    $this->com->SetSeriesCaption($index,$caption);
    }

  function SetSeriesCaptionsFromArray($captions)
    {
    $this->com->SetSeriesCaptionsFromArray($captions);
    }

  function SetSeriesCaptionsFromString($captions)
    {
    $this->com->SetSeriesCaptionsFromString($captions);
    }

  function SetSeriesValuesFromArray($index, $array)
    {
    $this->com->SetSeriesValuesFromArray($index,$array);
    }

  function SetSeriesValuesFromString($index, $values)
    {
    $this->com->SetSeriesValuesFromString($index,$values);
    }

  function SetSeriesXValuesFromArray($index, $array)
    {
    $this->com->SetSeriesXValuesFromArray($index,$array);
    }

  function SetSeriesXValuesFromString($index, $values)
    {
    $this->com->SetSeriesXValuesFromString($index,$values);
    }

  function SetSeriesYValuesFromArray($index, $array)
    {
    $this->com->SetSeriesYValuesFromArray($index,$array);
    }

  function SetSeriesYValuesFromString($index, $values)
    {
    $this->com->SetSeriesYValuesFromString($index,$values);
    }

  function SetSeriesXYValuesFromString($index, $values)
    {
    $this->com->SetSeriesXYValuesFromString($index,$values);
    }

  function SetSubtitle($title)
    {
    $this->com->SetSubtitle($title);
    }

  function SetTitle($title)
    {
    $this->com->SetTitle($title);
    }

  function SetUnicode($unicode)
    {
    $this->com->SetUnicode($unicode);
    }

  function SetWidth($width)
    {
    $this->com->SetWidth($width);
    }

  function SetAxisMinValue($axis_number, $min_value)
    {
    $this->com->SetAxisMinValue($axis_number,$min_value);
    }

  function SetAxisMaxValue($axis_number, $max_value)
    {
    $this->com->SetAxisMaxValue($axis_number,$max_value);
    }

  function SetAxisCrossValue($axis_number, $cross_value)
    {
    $this->com->SetAxisCrossValue($axis_number,$cross_value);
    }

  function ResetAxisBounds($axis_number)
    {
    $this->com->ResetAxisBounds($axis_number);
    }
}

?>
