/*
* Copyright (C) 2008-2010, GlobFX Technologies, SARL.
* All Rights Reserved.
* This is UNPUBLISHED PROPRIETARY SOURCE CODE of GlobFX Technologies, SARL.
* The contents of this file may not be disclosed to third parties, copied or
* duplicated in any form, in whole or in part, without the prior written
* permission of GlobFX Technologies, SARL.
*/

package com.globfx.showroom
{
  /**
   *  <p>The Slide class represents a PowerPoint slide of the current presentation.</p>
   *  <p>It can be retrieved through the SlideShow or Presentation objects.</p>
   *  
   *  @see com.globfx.showroom.SlideShow
   *  @see com.globfx.showroom.Presentation
   */
  public class Slide
  {
    private var _pres : Presentation = null;
    private var _number : int = 0;
    private var _title : String = null;
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     * @private
     */
    internal function _init( pres : Presentation, number : int ) : Boolean
    {
      _pres= pres;
      _number= number;
      
      return true;
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     * @private
     */
    internal function _dispose() : void
    {
      _number= 0;
      _pres= null;
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     *  Returns the number of this slide.
     */
    public function get number() : int
    {
      return _number;
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     *  Returns the title of this slide or "" if the slide has no title.
     */
    public function get title() : String
    {
      if( _title == null )
        _title= String( _pres.showroom.api.GetSlideTitle(_number) );
      return _title;
    }
    
    /////////////////////////////////////////////////////////////////////////
  }
}
