/*
* Copyright (C) 2008-2010, GlobFX Technologies, SARL.
* All Rights Reserved.
* This is UNPUBLISHED PROPRIETARY SOURCE CODE of GlobFX Technologies, SARL.
* The contents of this file may not be disclosed to third parties, copied or
* duplicated in any form, in whole or in part, without the prior written
* permission of GlobFX Technologies, SARL.
*/

package com.globfx.showroom
{
  /**
   *  <p>The VisitedSlide class contains information on a previously visited slide.</p>
   *  <p>It can be retrieved through the <code>ShowRoom.slideShow.history</code> property.</p>
   *  
   *  @see com.globfx.showroom.SlideShow
   *  @see com.globfx.showroom.SlideShow#history
   */
  public class VisitedSlide
  {
    private var _slide : Slide = null;
    private var _date_entered : Date = null;
    private var _elapsed : Number = 0; // seconds
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     * @private
     */
    internal static function _create( slide : Slide,
                                      date_entered : Date,
                                      elapsed : Number ) : VisitedSlide
    {
      var vs : VisitedSlide = new VisitedSlide();
      vs._slide= slide;
      vs._date_entered= date_entered;
      vs._elapsed= elapsed;
      
      return vs;      
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     *  Returns the visited slide.
     */
    public function get slide() : Slide
    {
      return _slide;
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     *  Returns the date and time the slide was entered.
     */
    public function get dateEntered() : Date
    {
      return _date_entered;
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     *  Returns the elapsed time on the slide, in seconds.
     */
    public function get elapsed() : Number
    {
      return _elapsed;
    }
    
    /////////////////////////////////////////////////////////////////////////
  }
}
