/*
* Copyright (C) 2008-2010, GlobFX Technologies, SARL.
* All Rights Reserved.
* This is UNPUBLISHED PROPRIETARY SOURCE CODE of GlobFX Technologies, SARL.
* The contents of this file may not be disclosed to third parties, copied or
* duplicated in any form, in whole or in part, without the prior written
* permission of GlobFX Technologies, SARL.
*/

package com.globfx.showroom
{
  /**
   *  <p>The IShowRoomContent interface helps ShowRoom to resize a loaded Flash.
   *     If the Flash is a Flex application, its main object will always implement mx.core.IFlexDisplayObject and
   *     ShowRoom will propertly scale it by calling the <code>setActualSize()</code> function through the 
   *     IFlexDisplayObject interface.</p>
   *  <p>However if the main Flash class does not implement IFlexDisplayObject, it can implement
   *     IShowRoomContent to be properly scaled when loaded by ShowRoom.</p>
   *  <p>If the Flash is running into the PowerPoint slide (not full screen), the size
   *     of the Flash is the same as the stage size. The Flash could use the stage size
   *     (once added to the stage) to resize and layout itself. It can also implement the
   *     IShowRoomContent interface.</p>
   *  <p>If the Flash is running in full screen mode during the PowerPoint Slide Show,
   *     it must implement this interface to properly resize and layout itself.</p>
   *  
   */
  public interface IShowRoomContent
  {
    /**
     *  <p>This method is called when ShowRoom resizes the loaded Flash. 
     *     The Flash should layout itself to fit this new size.</p>
     * 
     *  @param newWidth The new width for this object.
     * 
     *  @param newHeight The new height for this object.
     *  
     */
    function setShowRoomContentSize( newWidth : Number, newHeight : Number ) : void;
  }
}
