/*
* Copyright (C) 2008-2010, GlobFX Technologies, SARL.
* All Rights Reserved.
* This is UNPUBLISHED PROPRIETARY SOURCE CODE of GlobFX Technologies, SARL.
* The contents of this file may not be disclosed to third parties, copied or
* duplicated in any form, in whole or in part, without the prior written
* permission of GlobFX Technologies, SARL.
*/

package com.globfx.showroom
{
  import flash.display.BitmapData;
  
  ///////////////////////////////////////////////////////////////////////////
  
  /**
   *  <p>The SwiffPlayerBackground class represents the background bitmap
   *     behind the Swiff Player shape during the slide show.</p>
   *  <p>This bitmap can be used only if the Flash is set transparent. To make
   *     a Flash transparent, check the "Transparent" check box in the shape properties.</p>
   *
   *  <p>It can be retrieved through the <code>ShowRoom.background</code> property.</p>
   *  
   *  @see com.globfx.showroom.ShowRoom
   *  @see com.globfx.showroom.ShowRoom#background
   */
  public class SwiffPlayerBackground
  {
    /////////////////////////////////////////////////////////////////////////
    
    private var _showroom : ShowRoom = null;
    private var _visible : Boolean = true;
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     * @private
     */
    internal function _init( showroom : ShowRoom, info : * ) : Boolean
    {
      _showroom= showroom;
      return true;
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     * @private
     */
    internal function _dispose() : void
    {
      if( _showroom != null )
      {
        _showroom= null;
      }
    }
    
    /////////////////////////////////////////////////////////////////////////
    
    /**
     * Whether or not the background bitmap behind the Swiff Player is visible.
     *
     * @default true
     */
    public function get visible() : Boolean
      {
      return _visible;
      }

    /**
     * @private
     */
    public function set visible( value : Boolean ) : void
      {
      if( value == _visible )
        return;
      _visible= value;
      _showroom.api.Background_SetVisible(value);
      }
    
    /////////////////////////////////////////////////////////////////////////

    /**
     * The BitmapData object containing the background behind the Swiff Player Shape during the slide show.
     *
     */
    public function get bitmapData() : flash.display.BitmapData
      {
      return flash.display.BitmapData( _showroom.api.Background_GetBitmapData() );
      }

    /////////////////////////////////////////////////////////////////////////

  }
}
